/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.init;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.core.Registry;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import superlord.goblinsanddungeons.world.structures.LargeGoblinCampStructure;
import superlord.goblinsanddungeons.world.structures.LargeGoblinCampStructurePiece;
import superlord.goblinsanddungeons.world.structures.MediumGoblinCampStructure;
import superlord.goblinsanddungeons.world.structures.MediumGoblinCampStructurePiece;
import superlord.goblinsanddungeons.world.structures.RuinedKeepStructure;
import superlord.goblinsanddungeons.world.structures.RuinedKeepStructurePiece;
import superlord.goblinsanddungeons.world.structures.SmallGoblinCampStructure;
import superlord.goblinsanddungeons.world.structures.SmallGoblinCampStructurePiece;

@Mod.EventBusSubscriber(modid="goblinsanddungeons", bus=Mod.EventBusSubscriber.Bus.MOD)
public class StructureInit {
    public static final StructureFeature<NoneFeatureConfiguration> SMALL_GOBLIN_CAMP = new SmallGoblinCampStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final StructureFeature<NoneFeatureConfiguration> MEDIUM_GOBLIN_CAMP = new MediumGoblinCampStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final StructureFeature<NoneFeatureConfiguration> LARGE_GOBLIN_CAMP = new LargeGoblinCampStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static final StructureFeature<NoneFeatureConfiguration> RUINED_KEEP = new RuinedKeepStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
    public static StructurePieceType SMALL_GOBLIN_CAMP_PIECE;
    public static StructurePieceType MEDIUM_GOBLIN_CAMP_PIECE;
    public static StructurePieceType LARGE_GOBLIN_CAMP_PIECE;
    public static StructurePieceType RUINED_KEEP_PIECE;

    static StructurePieceType setPieceId(StructurePieceType.StructureTemplateType type, String name) {
        return (StructurePieceType)Registry.m_122961_((Registry)Registry.f_122843_, (String)name.toLowerCase(Locale.ROOT), (Object)type);
    }

    @SubscribeEvent
    public static void registerFeature(RegistryEvent.Register<StructureFeature<?>> registry) {
        registry.getRegistry().register((IForgeRegistryEntry)((StructureFeature)SMALL_GOBLIN_CAMP.setRegistryName("goblinsanddungeons:small_goblin_camp")));
        registry.getRegistry().register((IForgeRegistryEntry)((StructureFeature)MEDIUM_GOBLIN_CAMP.setRegistryName("goblinsanddungeons:medium_goblin_camp")));
        registry.getRegistry().register((IForgeRegistryEntry)((StructureFeature)LARGE_GOBLIN_CAMP.setRegistryName("goblinsanddungeons:large_goblin_camp")));
        registry.getRegistry().register((IForgeRegistryEntry)((StructureFeature)RUINED_KEEP.setRegistryName("goblinsanddungeons:ruined_keep")));
    }

    public static void init() {
        SMALL_GOBLIN_CAMP_PIECE = StructureInit.setPieceId(SmallGoblinCampStructurePiece.Piece::new, "SGCSP");
        MEDIUM_GOBLIN_CAMP_PIECE = StructureInit.setPieceId(MediumGoblinCampStructurePiece.Piece::new, "MGCSP");
        LARGE_GOBLIN_CAMP_PIECE = StructureInit.setPieceId(LargeGoblinCampStructurePiece.Piece::new, "LGCSP");
        RUINED_KEEP_PIECE = StructureInit.setPieceId(RuinedKeepStructurePiece.Piece::new, "RKSP");
    }

    private static String prefix(String path) {
        return "goblinsanddungeons:" + path;
    }
}

